
library(runjags)
load("data_500.RData")

# selection model

selection<- "
model{
  # likelihood
  for (i in 1:N){
    R[i] ~ dbern(p[i])
    logit(p[i]) = a0 + a1*EPT[i]
    EPT[i] ~ dnorm(mu.EPT[i], pre.EPT) 
    mu.EPT[i] <- b0 + b1*REASON[i] + b2*AGE[i]
    WS[i] ~ dnorm(mu1[i], pre.WS)
    LT[i] ~ dnorm(mu2[i], pre.LT)
    LS[i] ~ dnorm(mu3[i], pre.LS)
    mu1[i] <- REASON[i] + k.WS
    mu2[i] <- l.LT*REASON[i] + k.LT
    mu3[i] <- l.LS*REASON[i] + k.LS
    REASON[i] ~ dnorm(0, pre.REASON)
  }
  
  # priors
  # regression model
  b0 ~ dnorm(0, pre.b)
  b1 ~ dnorm(0, pre.b)
  b2 ~ dnorm(0, pre.b)
  a0 ~ dnorm(0, pre.a)
  a1 ~ dnorm(0, pre.a)
  pre.a ~ dgamma(.001,.001)
  pre.b ~ dgamma(.001,.001)
  pre.EPT ~ dgamma(0.001, 0.001)
  
  # factor model
  l.LT ~ dnorm(0, 0.001)
  l.LS ~ dnorm(0, 0.001)
  pre.WS ~ dgamma(0.001, 0.001)
  pre.LT ~ dgamma(0.001, 0.001)
  pre.LS ~ dgamma(0.001, 0.001)
  k.WS ~ dnorm(0, 0.001)
  k.LT ~ dnorm(0, 0.001)
  k.LS ~ dnorm(0, 0.001)
  pre.REASON ~ dgamma(0.001, 0.001)
  
  # variances
  var.EPT <- 1/pre.EPT
  var.WS <- 1/pre.WS
  var.LT <- 1/pre.LT
  var.LS <- 1/pre.LS
  var.REASON <- 1/pre.REASON
}
 
"
data <- list(N = 500, 
             EPT = data_500_mnar$EPT,
             AGE = data_500_mnar$AGE,
             WS = data_500_mnar$WS,
             LT = data_500_mnar$LT,
             LS = data_500_mnar$LS,
             R = is.na(data_500_mnar$EPT)*1)


inits <- list(list(b0=0, b1=0, b2=0, l.LT=0, l.LS=0, 
                   k.WS=0, k.LS=0, k.LT=0, 
                   pre.WS=0.1, pre.LS=0.1, pre.LT=0.1,
                   pre.EPT=0.1, pre.REASON=0.1,
                   a0=0.1, a1=0.1),
              list(b0=1, b1=1, b2=1, l.LT=1, l.LS=1, 
                   k.WS=1, k.LS=1, k.LT=1, 
                   pre.WS=0.2, pre.LS=0.2, pre.LT=0.2,
                   pre.EPT=0.2, pre.REASON=0.2,
                   a0=0.2, a1=0.2))

out1 <- run.jags(model=selection, 
                 monitor=c("b0", "b1", "b2",
                 "a0", "a1",
                 "l.LT", "l.LS", "k.WS", 
                 "k.LT", "k.LS",
                 "var.WS", "var.LT", 
                 "var.LS", "var.EPT", "var.REASON"),
                 data=data, n.chains=2, 
                 inits=inits, method="simple",
                 adapt=1000, burnin = 3000,
                 sample=1000000, 
                 thin=1,
                 keep.jags.files=FALSE,
                 tempdir=TRUE)
options(digits=3)
library(knitr)
kable(summary(out1)[, c("Lower95","Median", 
                        "Upper95", "Mean",
                        "MCerr", "SSeff", 
                        "psrf")], "latex")
plot(out1)
save(out1, file="selection.RData")



