library(runjags)

load("data_500.RData")

# nonignorable pattern mixture model


pmm <- "
model{
  # likelihood
  for (i in 1:N){
    EPT[i] ~ dnorm(mu.EPT[i], pre.EPT) 
    mu.EPT[i] <- b0[R[i]+1] + b1[R[i]+1]*REASON[i] + b2*AGE[i]
    WS[i] ~ dnorm(mu1[i], pre.WS)
    LT[i] ~ dnorm(mu2[i], pre.LT)
    LS[i] ~ dnorm(mu3[i], pre.LS)
    mu1[i] <- REASON[i] + k.WS
    mu2[i] <- l.LT*REASON[i] + k.LT
    mu3[i] <- l.LS*REASON[i] + k.LS
    REASON[i] ~ dnorm(0, pre.REASON)
  }
  
  # priors
  # regression model
  b0[1] ~ dnorm(0, pre.b) # non-missing
  b0[2] ~ dnorm(b0[1]+05, pre.b) #missing
  b1[1] ~ dnorm(0, pre.b) # non-missing
  b1[2] ~ dnorm(b1[1]-0.5, pre.b) #missing
  b2 ~ dnorm(0, pre.b)
  pre.b ~ dgamma(.001,.001)
  pre.EPT ~ dgamma(0.001, 0.001)
  
  # factor model
  l.LT ~ dnorm(0, 0.001)
  l.LS ~ dnorm(0, 0.001)
  pre.WS ~ dgamma(0.001, 0.001)
  pre.LT ~ dgamma(0.001, 0.001)
  pre.LS ~ dgamma(0.001, 0.001)
  k.WS ~ dnorm(0, 0.001)
  k.LT ~ dnorm(0, 0.001)
  k.LS ~ dnorm(0, 0.001)
  pre.REASON ~ dgamma(0.001, 0.001)
  
  # variances
  var.EPT <- 1/pre.EPT
  var.WS <- 1/pre.WS
  var.LT <- 1/pre.LT
  var.LS <- 1/pre.LS
  var.REASON <- 1/pre.REASON
}
 
"

data <- list(N = 500, 
             EPT = data_500_mnar_2$EPT,
             AGE = data_500_mnar_2$AGE,
             WS = data_500_mnar_2$WS,
             LT = data_500_mnar_2$LT,
             LS = data_500_mnar_2$LS,
             R = is.na(data_500_mnar_2$EPT)*1)



inits <- list(list(b0=c(0,1), b1=c(1,0), b2=0, 
                   l.LT=0, l.LS=0, k.WS=0,
                   k.LS=0, k.LT=0, 
                   pre.WS=0.1, pre.LS=0.1, pre.LT=0.1,
                   pre.EPT=0.1, pre.REASON=0.1),
              list(b0=c(1,2), b1=c(2,1), b2=1, 
                   l.LT=1, l.LS=1, k.WS=1, 
                   k.LS=1, k.LT=1, 
                   pre.WS=0.2, pre.LS=0.2, pre.LT=0.2,
                   pre.EPT=0.2, pre.REASON=0.2))

out1 <- run.jags(model=pmm, 
                 monitor=c("b0", "b1", "b2", 
                "l.LT", "l.LS",
                "k.WS", "k.LT", "k.LS", 
                "var.WS", "var.LT", 
                "var.LS", "var.EPT", "var.REASON"),
                 data=data, n.chains=2, 
                 inits=inits, method="simple",
                 adapt=1000, burnin = 3000,
                 sample=1000000, 
                 thin=1,
                 keep.jags.files=FALSE,
                 tempdir=TRUE)

options(digits=3)
plot(out1)
save(out1, file="pmm.RData")
library(knitr)
kable(summary(out1)[, c("Lower95","Median", 
                        "Upper95", "Mean",
                        "MCerr", "SSeff",
                        "psrf")], "latex")

